<?php


namespace App\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use NumberFormatter;

class Money implements CastsAttributes
{

    public function get($model, string $key, $value, array $attributes)
    {
        return self::format($value);
    }

    public function set($model, string $key, $value, array $attributes)
    {
        return round($value, 2);
    }

    public static function format($value): array
    {
        $fmt = new NumberFormatter('ASIA\KOLKATA', NumberFormatter::CURRENCY);

        return [
            'currency' => $fmt->formatCurrency($value, 'INR'),
            'amount' => round($value, 2),
        ];
    }
}
