<?php

namespace App\DataTables;

use App\Models\Deals\Deal;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;

class DealDataTable extends DataTable
{
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->editColumn('status', 'admin.shared.status')
            ->addColumn('actions', 'admin.deal.action')
            ->rawColumns(['status', 'actions']);
    }

    public function query(Deal $model)
    {
        return $model->newQuery();
    }

    public function html()
    {
        return $this->builder()
            ->setTableId('deal-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->dom('Bfrtip')
            ->orderBy(1)
            ->buttons(
                Button::make('create'),
                Button::make('export'),
                Button::make('print'),
                Button::make('reset'),
                Button::make('reload')
            );
    }

    protected function getColumns()
    {
        return [
            Column::make('id'),
            Column::make('name'),
            Column::make('status'),
            Column::make('actions'),
        ];
    }

    protected function filename()
    {
        return 'Deal_' . date('YmdHis');
    }
}
