<?php

namespace App\DataTables;

use App\Models\User;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;

class VendorDatatable extends DataTable
{
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->addColumn('status', 'admin.shared.status')
            ->addColumn('actions', 'admin.vendor.action')
            ->rawColumns(['status', 'actions']);
    }

    public function query(User $model)
    {
        return $model->newQuery()->role('merchant');
    }

    public function html()
    {
        return $this->builder()
            ->setTableId('vendordatatable-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->dom('Bfrtip')
            ->orderBy(1)
            ->buttons(
                Button::make('create'),
                Button::make('export'),
                Button::make('print'),
                Button::make('reset'),
                Button::make('reload')
            );
    }

    protected function getColumns()
    {
        return [
            Column::make('id'),
            Column::make('name'),
            Column::make('phone'),
            Column::make('email'),
            Column::make('merchant_type')->title('Type'),
            Column::make('status'),
            Column::make('actions'),
        ];
    }

    protected function filename()
    {
        return 'Vendor_' . date('YmdHis');
    }
}
