<?php

namespace App\Http\Controllers\API\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class DeliveryAuthController extends Controller
{
    public function login(Request $request): JsonResponse
    {
        $data = $request->all();

        $validator = Validator::make($data, [
            'phone' => ['required', 'digits:10'],
            'password' => ['required', 'string'],
        ]);

        if ($validator->fails()) {
            return response()
                ->json(['error' => $validator->errors()->first()], 422);
        }

        $customer = User::query()
            ->role('delivery')
            ->wherePhone($data['phone'])
            ->first();

        if (!$customer || !Hash::check($data['password'], $customer->password)) {
            return response()->json([
                'status' => false,
                'message' => 'The provided credentials are incorrect.'
            ], 401);
        }

        return response()->json([
            'status' => true,
            'token' => $customer->createToken($data['phone'], ['role:delivery'])->plainTextToken,
            'user' => $customer,
        ]);
    }

    public function logout()
    {
        auth()->user()->currentAccessToken()->delete();
    }
}
