<?php

namespace App\Http\Controllers\API\Customer\Address;

use App\Http\Controllers\Controller;
use App\Models\Addresses\Address;
use Illuminate\Http\Request;

class AddressController extends Controller
{
    public function index()
    {
        return Address::query()
            ->where('customer_id', auth()->id())
            ->where('deleted', false)
            ->get();
    }

    public function store(Request $request)
    {
        $data = $request->all();

        $data['customer_id'] = auth()->id();

        Address::query()->create($data);
    }

    public function destroy(Address $address)
    {
        $address->update(['deleted' => true]);
    }
}
