<?php

namespace App\Http\Controllers\API\Customer\Brand;

use App\Http\Controllers\Controller;
use App\Http\Resources\Brand\BrandResource;
use App\Http\Resources\Product\ProductResource;
use App\Models\Brands\Brand;
use App\Models\Products\Product;
use Illuminate\Http\Request;

class BrandController extends Controller
{
    public function show($id): array
    {
        $brand = Brand::query()
            ->where('id', $id)
            ->first();

        $products = Product::query()
            ->where('brand_id', $brand->id)
            ->has('variants')
            ->active()
            ->relations()
            ->get();

        return [
            'brand' => BrandResource::make($brand),
            'products' => ProductResource::collection($products),
        ];
    }
}
