<?php

namespace App\Http\Controllers\API\Customer\Checkout;

use Illuminate\Http\Request;
use App\Services\PaymentService;
use App\Http\Controllers\Controller;

class CheckoutController extends Controller
{
    protected PaymentService $paymentService;

    /** @noinspection PhpMissingParentConstructorInspection */
    public function __construct(PaymentService $service)
    {
        $this->paymentService = $service;
    }

    public function createOrder(Request $request)
    {
        return $this->paymentService->createOrder($request->amount, $request->receipt);
    }
}
