<?php

namespace App\Http\Controllers\API\Customer\Deal;

use App\Http\Controllers\Controller;
use App\Http\Resources\Product\ProductResource;
use App\Models\Categories\Category;
use App\Models\Products\Product;
use Illuminate\Http\Request;

class DealController extends Controller
{
    public function show(Category $category)
    {
        $products = Product::query()
            ->where('subcategory_id', $category->id)
            ->has('variants')
            ->active()
            ->relations()
            ->get();

        return ProductResource::collection($products);
    }
}
