<?php

namespace App\Http\Controllers\API\Customer\Order;

use App\Http\Controllers\Controller;
use App\Http\Resources\Order\OrderProductResource;
use App\Mail\OrderShipped;
use App\Models\Delivery\Delivery;
use App\Models\Orders\Order;
use App\Models\Wallets\Wallet;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Illuminate\Support\Facades\Mail;

class OrderController extends Controller
{
    public function store(Request $request)
    {
        try {
            return $this->orderService->create($request);
        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }

    public function show(Order $order): AnonymousResourceCollection
    {
        $products = $order->products()->latest()->get();

        return OrderProductResource::collection($products);
    }

    public function update(Request $request, Order $order)
    {
        if (isset($request->start_date)) {
            $order->update([
                'start_date' => $request->start_date,
                'end_date' => $request->end_date,
            ]);

            $order->deliveries()->delete();
        }

        if (isset($request->payment_id)) {
            $data = $request->all();

            $data['payment_status'] = Order::PAYMENT_SUCCESS;
            $data['status'] = Order::ORDER_ACTIVE;

            $order->update($data);
        }

        if (isset($request->status)) {
            $this->cancelOrder($request, $order);
        }
    }

    public function confirmOrder(Order $order)
    {
        $order->update(['confirmed' => true]);
    }

    protected function cancelOrder(Request $request, Order $order)
    {
        if ($order->payment_status == Order::PAYMENT_SUCCESS) {
            $customerId = $order->customer_id;
            $amount = $order->total['amount'];
            $paymentMethod = $order->payment_method;

            if ($paymentMethod == Order::PM_COUPON) {
                Wallet::query()
                    ->where('user_id', $customerId)
                    ->increment('coupon', $amount);
            } else {
                if ($paymentMethod != Order::PM_COD) {
                    $this->transaction->credit($customerId, $amount);
                }
            }
        }


        $data = $request->all();
        $data['status'] = Order::ORDER_FAILED;

        $order->deliveries()->update(['status' => Delivery::STATUS_CANCELLED]);

        $order->update($data);
    }
}
