<?php

namespace App\Http\Controllers\API\Customer\Order;

use App\Http\Controllers\Controller;
use App\Models\Orders\Order;

class OrderIndexController extends Controller
{
    public function package()
    {
        return Order::query()
            ->where('customer_id', auth()->id())
            ->where('type', 'package')
            ->whereNotIn('status', [Order::ORDER_FAILED, Order::ORDER_PENDING])
            ->latest()
            ->get();
    }

    public function all()
    {
        return Order::query()
            ->where('customer_id', auth()->id())
            ->latest()
            ->get();
    }
}
