<?php

namespace App\Http\Controllers\API\Delivery\Delivery;

use App\Http\Controllers\Controller;
use App\Http\Resources\Delivery\DeliveryOrderResource;
use App\Models\Delivery\Delivery;
use App\Models\Orders\Order;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class DeliveryRequestController extends Controller
{
    public function index(): AnonymousResourceCollection
    {
        $orders = Order::query()
            ->has('address')
            ->has('customer')
            ->with('address')
            ->with('deliveries', function ($query) {
                return $query
                    ->whereNull('delivery_id')
                    ->whereDate('date', now())
                    ->where('postcode', auth()->user()->postcode)
                    ->has('product')
                    ->has('variation')
                    ->with(['product', 'variation']);
            })
            ->has('deliveries')
            ->latest()
            ->get()
            ->filter(function ($order, $key) {
                return count($order->deliveries) > 0;
            });

        return DeliveryOrderResource::collection($orders);
    }

    public function update(Request $request): AnonymousResourceCollection
    {
        $deliveries = json_decode($request->delivery_ids);

        Delivery::query()
            ->whereIn('id', $deliveries)
            ->update(['delivery_id' => auth()->id()]);

        return $this->index();
    }
}
