<?php

namespace App\Http\Controllers\API\Vendor\Home;

use App\Http\Controllers\Controller;
use App\Http\Resources\Product\ProductResource;
use App\Http\Resources\Product\RequirementResource;
use App\Models\Products\Product;
use App\Models\Products\ProductRequirement;
use Illuminate\Http\JsonResponse;

class HomeController extends Controller
{
    public function index(): JsonResponse
    {
        $requirements = ProductRequirement::with(['product', 'variant'])
            ->latest()
            ->take(3)
            ->get();

        $products = Product::query()
            ->where('vendor_id', auth()->id())
            ->latest()
            ->take(2)
            ->relations()
            ->get();

        return response()->json([
            'requirements' => RequirementResource::collection($requirements),
            'products' => ProductResource::collection($products),
        ]);
    }
}
