<?php

namespace App\Http\Controllers\API\Vendor\Invoice;

use App\Http\Controllers\Controller;
use App\Http\Resources\Customer\CustomerResource;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class DeliveryPartnerController extends Controller
{
    public function index(): AnonymousResourceCollection
    {
        $users = User::query()
            ->where('employer_id', auth()->id())
            ->role('delivery')
            ->get();

        return CustomerResource::collection($users);
    }

    public function store(Request $request)
    {
        $data = $request->all();

        $validator = Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'phone' => ['required', 'digits:10', 'unique:users'],
            'email' => ['email', 'unique:users'],
            'password' => ['required', 'string', 'min:6'],
        ]);

        if ($validator->fails()) {
            return response()
                ->json(['error' => $validator->errors()->first()], 422);
        }

        $data['employer_id'] = auth()->id();
        $data['password'] = Hash::make($data['password']);

        /** @var User $customer */
        $customer = User::query()->create($data);

        $customer->assignRole('delivery');
        $customer->wallet()->create();
    }
}
