<?php

namespace App\Http\Controllers\API\Vendor\Product;

use App\Http\Controllers\Controller;
use App\Http\Resources\Product\ProductResource;
use App\Models\Products\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ProductController extends Controller
{
    public function index()
    {
        $products = Product::query()
            ->where('vendor_id', auth()->id())
            ->latest()
            ->relations()
            ->get();

        return ProductResource::collection($products);
    }

    public function store(Request $request)
    {
        $data = $request->all();

        $validator = Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'image' => ['required', 'image'],
            'description' => ['required', 'string'],

            'brand_id' => ['required'],
            'category_id' => ['required'],
            'subcategory_id' => ['required'],
        ]);

        if ($validator->fails()) {
            return response()
                ->json(['error' => $validator->errors()->first()], 422);
        }

        $data['vendor_id'] = auth()->id();
        $data['status'] = 'inactive';
        $data['in_stock'] = false;
        $data['image'] = $this->fileService->store('image', 'products');

        /** @var Product $product */
        $product = Product::query()->create($data);

        foreach (json_decode($data['variants']) as $variant) {
            $product->variants()->create([
                'unit' => $variant->unit,
                'mrp' => $variant->mrp,
                'description' => 'From Vendor',
            ]);
        }

        return response()->json(['success' => 'Product Successfully Added!']);
    }
}
