<?php

namespace App\Http\Controllers\Admin\Banner;

use Illuminate\Http\Request;
use App\Models\Banners\Banner;
use App\Models\Categories\Category;
use App\Http\Controllers\Controller;

class BannerController extends Controller
{
    public function index()
    {
        $banner = Banner::latest()->first();
        $categories = Category::whereParentId(null)->get();

        if (!isset($banner)) {
            $banner = Banner::create();
        }

        return view('admin.banner.edit', compact('banner', 'categories'));
    }

    public function update(Request $request, Banner $banner)
    {
        $data = [];

        for ($i = 1; $i <= 15; $i++) {
            $image = "image$i";
            $category = "cat$i";

            $data[$image] = $this->fileService->checkAndStore($image, 'banners', $banner->{$image});
            $data[$category]  = $request[$category];
        }

        // Updating Banner
        $banner->update($data);

        return redirect()->back()->with('success', 'Banner Changed!');
    }
}
