<?php

namespace App\Http\Controllers\Admin\Category;

use App\Models\Categories\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CategoryChildController extends Controller
{
    public function create(Category $category)
    {
        return view('admin.categories.child.create', compact('category'));
    }

    public function store(Request $request, Category $category)
    {
        $data = $request->all();

        $data['parent_id'] = $category->id;
        $data['image'] = $this->fileService->store('image', 'categories');

        Category::query()->create($data);

        return redirect()->route('categories.show', $category->id)->with('success', 'Category Created!');
    }

    public function edit(Category $category, Category $child)
    {
        return view('admin.categories.child.edit ', compact('category', 'child'));
    }

    public function update(Request $request, Category $category, Category $child)
    {
        $data = $request->all();
        $data['image'] = $this->fileService->checkAndStore('image', 'categories', $child->image);

        $child->update($data);

        return redirect()->route('categories.show', $category->id)->with('success', 'Category Updated!');
    }

    public function destroy(Category $category, Category $child)
    {
        $this->fileService->delete($child->image);
        $child->delete();

        return back()->with('info', 'Category Deleted');
    }
}
