<?php

namespace App\Http\Controllers\Admin\Common;

use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Models\Commons\Common;
use App\Http\Controllers\Controller;

class CommonController extends Controller
{
    public function privacy()
    {
        $data = $this->getData('privacy');

        return view('admin.commons.privacy', compact('data'));
    }

    public function updatePrivacy(Request $request)
    {
        $data = $this->getData('privacy');

        if ($data === '') {
            Common::create(['type' => 'privacy', 'body' => $request->privacy]);
        } else {
            Common::where('type', '=', 'privacy')->first()->update([
                'body' => $request->privacy,
            ]);
        }

        return back()->with('success', 'Updated Privacy Policy!');
    }

    public function terms()
    {
        $data = $this->getData('terms');

        return view('admin.commons.terms', compact('data'));
    }

    public function updateTerms(Request $request)
    {
        $data = $this->getData('terms');

        if ($data === '') {
            Common::create(['type' => 'terms', 'body' => $request->terms]);
        } else {
            Common::where('type', '=', 'terms')->first()->update([
                'body' => $request->terms,
            ]);
        }

        return back()->with('success', 'Updated Terms!');
    }

    public function about()
    {
        $data = $this->getData('about');

        return view('admin.commons.about', compact('data'));
    }

    public function updateAbout(Request $request): RedirectResponse
    {
        $data = $this->getData('about');

        if ($data === '') {
            Common::create(['type' => 'about', 'body' => $request->about]);
        } else {
            Common::where('type', '=', 'about')->first()->update([
                'body' => $request->about,
            ]);
        }

        return back()->with('success', 'Updated About!');
    }

    public function shipping()
    {
        $data = $this->getData('shipping');

        return view('admin.commons.shipping', compact('data'));
    }

    public function updateShipping(Request $request): RedirectResponse
    {
        $data = $this->getData('shipping');

        if ($data === '') {
            Common::create(['type' => 'shipping', 'body' => $request->shipping]);
        } else {
            Common::where('type', '=', 'shipping')->first()->update([
                'body' => $request->shipping,
            ]);
        }

        return back()->with('success', 'Updated Shipping!');
    }

    public function refund()
    {
        $data = $this->getData('refund');

        return view('admin.commons.refund', compact('data'));
    }

    public function updateRefund(Request $request): RedirectResponse
    {
        $data = $this->getData('refund');

        if ($data === '') {
            Common::create(['type' => 'refund', 'body' => $request->about]);
        } else {
            Common::where('type', '=', 'refund')->first()->update([
                'body' => $request->about,
            ]);
        }

        return back()->with('success', 'Updated Refund!');
    }

    protected function getData(string $type)
    {
        $common = Common::where('type', '=', $type)->first();

        if (isset($common)) {
            return $common->body;
        }

        return '';
    }
}
