<?php

namespace App\Http\Controllers\Admin\Common;

use App\Http\Controllers\Controller;
use App\Models\Commons\Donation;
use Illuminate\Http\Request;

class DonationController extends Controller
{
    public function index()
    {
        return view('admin.commons.donation.index');
    }

    public function create()
    {
        return view('admin.commons.donation.create');
    }

    public function store(Request $request)
    {
        $data = $request->all();

        $request->validate([
            'title' => 'required',
            'image' => 'required',
            'about' => 'required',
            'important' => 'required',
        ]);

        $data['image'] = $this->fileService->store('image', 'donation');

        Donation::query()->create($data);

        return redirect()->route('donations.index')->with('success', 'Donation Created!');
    }

    public function edit(Donation $donation)
    {
        return view('admin.commons.donation.edit', compact('donation'));
    }

    public function update(Request $request, Donation $donation)
    {
        $data = $request->all();

        $request->validate([
            'title' => 'required',
            'about' => 'required',
            'important' => 'required',
        ]);

        $data['image'] = $this->fileService->checkAndStore('image', 'donation', $donation->image);

        $donation->update($data);

        return redirect()->route('donations.index')->with('success', 'Donation Updated!');
    }

    public function destroy(Donation $donation)
    {
        $this->fileService->delete($donation->image);

        $donation->delete();

        return redirect()->route('donations.index')->with('success', 'Donation Deleted!');
    }
}
