<?php

namespace App\Http\Controllers\Admin\Deal;

use App\Http\Controllers\Controller;
use App\Models\Categories\Category;
use App\Models\Deals\Deal;
use App\Models\Products\Product;
use Illuminate\Http\Request;

class DealProductController extends Controller
{
    public function edit(Deal $deal)
    {
        $products = Category::query()
            ->whereNotNull('parent_id')
            ->latest()
            ->get();

        return view('admin.deal.products', compact('deal', 'products'));
    }

    public function update(Request $request, Deal $deal)
    {
        $deal->products()->sync($request->all());
    }
}
