<?php

namespace App\Http\Controllers\Admin\Delivery;

use App\Http\Controllers\Controller;
use App\Models\Delivery\Delivery;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class DeliveryController extends Controller
{
    public function index()
    {
        return view('admin.deliveries.index-today');
    }

    public function edit(Delivery $delivery)
    {
        return view('admin.deliveries.edit', compact('delivery'));
    }

    public function update(Request $request, Delivery $delivery): RedirectResponse
    {
        $data = $request->validate(['time' => 'required']);

        $delivery->update($data);

        return redirect()->route('deliveries.index')->with('success', 'Delivery Time Updated!');
    }

    public function destroy(Delivery $delivery): RedirectResponse
    {
        $delivery->delete();

        return back()->with('info', 'Delivery Deleted!');
    }
}
