<?php

namespace App\Http\Controllers\Admin\Delivery;

use App\Http\Controllers\Controller;
use App\Models\Pincodes\Pincode;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class DeliveryPartnerController extends Controller
{
    public function index()
    {
        $delivery = User::all();

        return view('admin.delivery-partner.index', compact('delivery'));
    }

    public function create()
    {
        $postcodes = Pincode::all();

        return view('admin.delivery-partner.create', compact('postcodes'));
    }

    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'postcode' => 'required',
            'password' => 'required',
        ]);

        $data = $request->all();
        $data['password'] = Hash::make($data['password']);

        $user = User::query()
            ->create($data)
            ->assignRole('delivery');

        $user->wallet()->create();

        return redirect()
            ->route('delivery-partners.index')
            ->with('success', 'Customer Created Successfully!');
    }

    public function edit(User $partner)
    {
        $postcodes = Pincode::all();

        return view('admin.delivery-partner.edit', compact('partner', 'postcodes'));
    }

    public function update(Request $request, User $partner): RedirectResponse
    {
        $data = $request->validate([
            'name' => 'required',
            'email' => 'required',
            'postcode' => 'required',
            'phone' => 'required',
        ]);

        if (isset($request->password)) {
            $data['password'] = Hash::make($request->password);
        }

        $partner->update($data);

        return redirect()
            ->route('delivery-partners.index')
            ->with('success', 'Info Updated Successfully');
    }

    public function destroy(User $partner): RedirectResponse
    {
        $partner->delete();

        return back()->with('info', 'Delivery Boy Deleted!');
    }
}
