<?php

namespace App\Http\Controllers\Admin\Order;

use App\Http\Controllers\Controller;
use App\Models\Orders\Order;
use App\Models\User;
use Illuminate\Http\Request;

class OrderAssignController extends Controller
{
    public function show(Order $order)
    {
        $vendors = User::query()->role('merchant')->get();

        return view('admin.order.assign', compact('order', 'vendors'));
    }

    public function update(Request $request, Order $order)
    {
        $data = $request->validate([
            'vendor_id' => 'required',
        ]);

        $order->update($data);

        return redirect()->back();
    }
}
