<?php

namespace App\Http\Controllers\Admin\Package;

use App\DataTables\BasketDataTable;
use App\Http\Controllers\Controller;
use App\Models\Packages\Basket;
use Illuminate\Http\Request;

class BasketController extends Controller
{
    public function index(BasketDataTable $table)
    {
        return $table->render('admin.basket.index');
    }

    public function create()
    {
        return view('admin.basket.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required',
            'name' => 'required',
            'duration' => 'required',
            'status' => 'required',
            'min_amount' => 'required',
            'discount_percentage' => 'required',
        ]);

        $data           = request()->all();
        $data['image']  = $this->fileService->store('image', 'basket');

        Basket::create($data);

        return redirect()->route('basket.index')->with('success', 'Plan Created Successfully!');
    }


    public function edit(Basket $basket)
    {
        return view('admin.basket.edit', compact('basket'));
    }

    public function update(Request $request, Basket $basket)
    {
        $request->validate([
            'name' => 'required',
            'duration' => 'required',
            'status' => 'required',
            'min_amount' => 'required',
            'discount_percentage' => 'required',
        ]);

        $data           = request()->all();
        $data['image']  = $this->fileService->checkAndStore('image', 'basket', $basket->image);

        $basket->update($data);

        return redirect()->route('basket.index')->with('success', 'Plan Update Successfully!');
    }

    public function destroy(Basket $basket)
    {
        $this->fileService->delete($basket->image);

        $basket->delete();

        return redirect()->route('basket.index')->with('info', 'Plan Deleted!');
    }
}
