<?php

namespace App\Http\Controllers\Admin\Package;

use App\Models\Categories\Category;
use Illuminate\Http\Request;
use App\Models\Packages\Package;
use App\Models\Products\Product;
use App\Http\Controllers\Controller;
use App\Models\Packages\PackageProdcut;

class PackageProductController extends Controller
{
    public function edit($id)
    {
        $products = Product::relations()->get();

        $categories = Category::query()
            ->whereNull('parent_id')
            ->get();

        $package = Package::query()
            ->where('id', $id)
            ->with('products')
            ->first();


        return view('admin.package.products', compact('package', 'products', 'categories'));
    }

    public function update(Request $request, Package $package)
    {
        $data = $request->all();

        foreach ($data['deleted'] as $id) {
            (PackageProdcut::find($id))->delete();
        }

        foreach ($data['update'] as $item) {
            (PackageProdcut::find($item['id']))->update($item);
        }

        foreach ($data['create'] as $item) {
            $packageProdcut = PackageProdcut::create($item);
            $packageProdcut->variations()->createMany($item['variations']);
        }
    }
}
