<?php

namespace App\Http\Controllers\Admin\Pincode;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pincodes\Pincode;

class PincodeController extends Controller
{
    public function index()
    {
        $pincode = Pincode::all();

        return view('admin.pincode.index', compact('pincode'));
    }

    public function create()
    {
        return view('admin.pincode.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'pincode' => 'required',

        ]);

        $data = $request->all();


        Pincode::query()->create($data);

        return redirect()->route('pincodes.index')->with('success', 'Customer Created Successfully!');
    }

    public function show($id)
    {
        //
    }

    public function edit(Pincode $pincode)
    {
        return view('admin.pincode.edit', compact('pincode'));
    }

    public function update(Request $request, Pincode $pincode)
    {
        $request->validate([
            'pincode' => 'required',
        ]);

        $pincode->update($request->all());

        return redirect()->route('pincodes.index')->with('success', 'Customer Updated Successfully');
    }


    public function destroy(Pincode $pincode)
    {
        $pincode->delete();

        return back()->with('info', 'Pincode Deleted!');
    }
}
