<?php

namespace App\Http\Controllers\Admin\Product;

use Illuminate\Http\Request;
use App\Models\Products\Product;
use App\Http\Controllers\Controller;
use App\Models\Products\Variant;

class ProductVariantController extends Controller
{
    public function edit(Product $product)
    {
        $variants = $product->variants;

        return view('admin.products.variant', compact('product', 'variants'));
    }

    public function update(Request $request, Product $product)
    {
        $data = $request->all();

        $request->validate([
            'variants.*.unit' => 'required',
            'variants.*.mrp' => 'required|numeric',
            'variants.*.discount_type' => 'required|string',
            'variants.*.description' => 'required|string',
        ]);

        foreach ($data['deleted'] as $id) {
            (Variant::find($id))->delete();
        }

        foreach ($data['variants'] as $item) {
            if (isset($item['id'])) {
                (Variant::find($item['id']))->update($item);
            } else {
                Variant::create($item);
            }
        }
    }
}
