<?php

namespace App\Http\Controllers\Admin\Slider;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Sliders\Slider;

class SliderChildController extends Controller
{
    public function create(Slider $slider)
    {
        return view('admin.sliders.child.create', compact('slider'));
    }

    public function store(Slider $slider, Request $request)
    {
        $data = $request->all();
        $data['image'] = $this->fileService->store('image', 'sliders');
        $data['parent_id'] = $slider->id;

        Slider::create($data);

        return redirect()->route('sliders.show', $slider->id)->with('success', 'Data Inserted Successfully');
    }

    public function edit(Slider $slider, Slider $child)
    {
        return view('admin.sliders.child.edit', compact('slider', 'child'));
    }

    public function update(Request $request, Slider $slider, Slider $child)
    {
        $data = $request->all();

        $data['image'] = $this->fileService->checkAndStore('image', 'sliders', $child->image);

        $child->update($data);

        return redirect()->route('sliders.show', $slider->id)->with('success', 'Slider Updated!');
    }

    public function destroy(Slider $slider, Slider $child)
    {
        $this->fileService->delete($child->image);
        $child->delete();

        return back()->with('info', 'Slider Deleted');
    }
}
