<?php

namespace App\Http\Controllers;

use App\Models\Orders\Service\OrderCreateService;
use App\Services\FileService;
use App\Services\TransactionService;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected FileService $fileService;

    protected TransactionService $transaction;

    protected OrderCreateService $orderService;

    protected $active;

    /**
     * Controller constructor.
     * @param FileService $fileService
     * @param TransactionService $transaction
     * @param OrderCreateService $orderService
     */
    public function __construct(FileService $fileService, TransactionService $transaction, OrderCreateService $orderService)
    {
        $this->fileService = $fileService;
        $this->transaction = $transaction;
        $this->orderService = $orderService;
        $this->active = function ($query) {
            $query->where('status', 'Active');
        };
    }
}
