<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Categories\Category;

class CategorySelect extends Component
{
    public $categories;
    public $subcategories;

    public $categoryId;
    public $subcategoryId;

    public $selectedCategory = null;
    public $selectedSubcategory = null;

    public function mount()
    {
        $this->categories = Category::whereParentId(null)->get();
        $this->subcategories = collect();

        if (isset($this->categoryId)) {
            $this->subcategories = Category::whereParentId($this->categoryId)->get();

            $this->selectedCategory = (Category::find($this->categoryId))->id;
            $this->selectedSubcategory = (Category::find($this->subcategoryId))->id;
        }
    }

    public function render()
    {
        return view('livewire.category-select');
    }

    public function updatedSelectedCategory($id)
    {
        $this->subcategories = Category::whereParentId($id)->get();
        $this->selectedSubcategory = null;
    }
}
