<?php

namespace App\Http\Livewire;

use App\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;

class CustomerTable extends DataTableComponent
{

    public function columns(): array
    {
        return [
            Column::make('NAME', 'name')->format(function ($value){
                return view('admin.shared.avatar')->with(['name' => $value]);
            })->searchable(),
            Column::make('PHONE', 'phone')->searchable(),
            Column::make('EMAIL', 'email')->searchable(),
            Column::make('ORDERS', 'orders_count'),
            Column::make('DUE', 'wallet.debt')->format(function ($value) {
                return "<span class='text-red'>{$value['currency']}</span>";
            })->asHtml(),
            Column::make('SINCE', 'created_at')->format(function ($value) {
                return $value->diffForHumans();
            }),
            Column::make('ACTIONS')->format(function ($value, $column, $row) {
                return view('admin.customer.action', compact('row'));
            }),
        ];
    }

    public function query(): Builder
    {
        return User::query()
            ->role('customer')
            ->with('wallet')
            ->withCount('orders')
            ->latest();
    }
}
