<?php

namespace App\Http\Livewire;

use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;
use App\Models\User;

class DeliveryPartnerDatatable extends DataTableComponent
{

    public function columns(): array
    {
        return [
            Column::make('NAME', 'name')->format(function ($value) {
                return view('admin.shared.avatar')->with(['name' => $value]);
            })->searchable(),

            Column::make('PHONE', 'phone'),
            Column::make('EMAIL', 'email'),
            Column::make('POSTCODE', 'postcode'),
            Column::make('ACTIONS')->format(function ($value, $column, $row) {
                return view('admin.delivery-partner.actions', compact('row'));
            }),
        ];
    }

    public function query(): Builder
    {
        return User::query()
            ->role('delivery');
    }
}
