<?php

namespace App\Http\Livewire;

use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;
use App\Models\Commons\Donation;

class DonationDatatable extends DataTableComponent
{

    public function columns(): array
    {
        return [
            Column::make('id'),
            Column::make('title'),
            Column::make('image')->format(function ($value) {
                return view('admin.shared.image')->with(['image' => $value]);
            }),
            Column::make('ACTIONS')->format(function ($value, $column, $row) {
                return view('admin.commons.donation.actions', compact('row'));
            }),
        ];
    }

    public function query(): Builder
    {
        return Donation::query()
            ->latest();
    }
}
