<?php

namespace App\Http\Livewire;

use App\Models\Products\Search;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;

class SearchTable extends DataTableComponent
{
    public array $bulkActions = [
        'delete' => 'DELETE',
    ];

    public function columns(): array
    {
        return [
            Column::make('QUERY', 'query'),
            Column::make('COUNT', 'count'),
            Column::make('TIME', 'created_at')->format(function ($value) {
                return $value->diffForHumans();
            }),
            Column::make('ACTIONS')->format(function ($value, $column, $row) {
                return view('admin.products.search.action', compact('row'));
            }),
        ];
    }

    public function query(): Builder
    {
        return Search::query()
            ->latest();
    }

    public function delete()
    {
        if ($this->selectedRowsQuery->count() > 0) {
            Search::query()
                ->whereIn('id', $this->selectedKeys())
                ->delete();
        }

        $this->resetBulk();
    }
}
