<?php

namespace App\Http\Resources\Category;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'image' => $this->image,
            $this->mergeWhen($this->parent_id == null, [
                'banner1' => $this->banner1,
                'banner2' => $this->banner2,
                'child' => CategoryResource::collection($this->whenLoaded('child')),
            ]),
        ];
    }
}
