<?php

namespace App\Http\Resources\Delivery;

use App\Casts\Money;
use App\Http\Resources\Address\AddressResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DeliveryOrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->order_id,

            'name' => $this->address->name,
            'phone' => $this->address->phone,
            'address' => $this->address->house . ', ' . $this->address->road . ', ' . $this->address->city . ', ' . $this->address->state . ', ' . $this->address->pin,

            'total' => Money::format($this->deliveries->sum('total'))['currency'],
            'amount' => Money::format($this->deliveries->sum('total'))['amount'],
            'payment_method' => $this->payment_method,

            'time' => $this->deliveries->firstWhere('time', '!=', null)->time ?? 'NOO',

            'women_delivery' => $this->women_delivery,
            'delivery_ids' => $this->deliveries->map(fn($item) => $item->id),
            'deliveries' => DeliveryPartnerResource::collection($this->whenLoaded('deliveries')),
        ];
    }
}
