<?php

namespace App\Http\Resources\Product;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'image' => $this->image,
            'description' => $this->description,
            'brand_id' => $this->brand_id,
            'brand' => $this->brand->name ?? '',
            'category' => $this->category->name ?? '',
            'subcategory' => $this->subcategory->name,
            'in_stock' => $this->in_stock,
            'variants' => VariantResource::collection($this->whenLoaded('variants')),
        ];
    }
}
