<?php

namespace App\Http\Resources\Product;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class VariantResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'unit' => $this->unit,
            'discount_type' => $this->discount_type,
            'discount' => $this->discount ?? 0,
            'mrp' => $this->mrp,
            'price' => $this->price,
            'description' => $this->description,
        ];
    }
}
