<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserEmail extends Mailable
{
    use Queueable, SerializesModels;

    public string $title;
    public string $msg;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(string $title, string $msg)
    {
        $this->title = $title;
        $this->msg = $msg;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build(): UserEmail
    {
        return $this
            ->subject($this->title)
            ->view('email.user-message');
    }
}
