<?php

namespace App\Models\Categories;

use App\Shared\Active;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property int $id
 */
class Category extends Model
{
    use HasFactory, Active;

    protected $fillable = [
        'name',
        'image',
        'banner1',
        'banner2',
        'status',
        'type',
        'parent_id',
    ];

    public function child(): HasMany
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }
}
