<?php

namespace App\Models\Customers;

use App\Models\Wallets\Transaction;
use App\Models\Wallets\Wallet;
use App\Shared\Active;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Sanctum\HasApiTokens;

class Customer extends Authenticatable
{
    use HasApiTokens, HasFactory, Active;

    protected $fillable = [
        'first_name',
        'last_name',
        'phone',
        'email',
        'password',

        'image',
        'aadhaar_front',
        'aadhaar_back',

        'status'
    ];

    protected $hidden = [
        'password'
    ];

    public function wallet(): MorphOne
    {
        return $this->morphOne(Wallet::class, 'walletable');
    }

    public function transactions(): MorphMany
    {
        return $this->morphMany(Transaction::class, 'transactionable');
    }
}
