<?php

namespace App\Models\Deals;

use App\Models\Categories\Category;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Deal extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'sort',
        'place',
        'status',
    ];

    public function products(): BelongsToMany
    {
        return $this->belongsToMany(Category::class, 'deal_product', 'deal_id', 'product_id');
    }
}
