<?php

namespace App\Models\Delivery;

use App\Models\Addresses\Address;
use App\Models\Orders\Order;
use App\Models\Orders\OrderProduct;
use App\Models\Orders\OrderVariation;
use App\Models\Products\Product;
use App\Models\Products\Variant;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Znck\Eloquent\Relations\BelongsToThrough;
use Znck\Eloquent\Traits\BelongsToThrough as Znck;

class Delivery extends Model
{
    use HasFactory, Znck;

    const STATUS_PENDING= 'pending';
    const STATUS_DELIVERED = 'delivered';
    const STATUS_CONFIRMED = 'confirmed';
    const STATUS_CANCELLED = 'cancelled';

    protected $fillable = [
        'area',
        'postcode',

        'order_id',

        'product_id',
        'variation_id',
        'customer_id',
        'delivery_id',

        'quantity',
        'date',
        'time',
        'status',
    ];

    protected $appends = ['total'];

    public function customer(): BelongsTo
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function address(): BelongsToThrough
    {
        return $this->belongsToThrough(Address::class, Order::class);
    }

    public function product(): BelongsToThrough
    {
        return $this->belongsToThrough(
            Product::class,
            OrderProduct::class,
            'product_id',
            '',
            [OrderProduct::class => 'product_id']
        );
    }

    public function variant(): BelongsToThrough
    {
        return $this->belongsToThrough(
            Variant::class,
            OrderVariation::class,
            'variant_id',
            '',
            [OrderVariation::class => 'variation_id']
        );
    }

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class, 'order_id');
    }

    public function item(): BelongsTo
    {
        return $this->belongsTo(OrderProduct::class, 'product_id')->with('product');
    }

    public function variation(): BelongsTo
    {
        return $this->belongsTo(OrderVariation::class, 'variation_id')->with('variant');
    }

    public function getTotalAttribute()
    {
        return $this->variant->price['amount'] * $this->quantity;
    }
}
