<?php

namespace App\Models\Orders;

use App\Models\Products\Variant;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderVariation extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_product_id',
        'variant_id',
        'quantity',
        'remaining_quantity',
        'total',
    ];

    public function variant(): BelongsTo
    {
        return $this->belongsTo(Variant::class);
    }
}
