<?php

namespace App\Models\Packages;

use App\Shared\Active;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Package extends Model
{
    use HasFactory, Active;

    protected $fillable = [
        'name',
        'image',
        'banner',
        'description',
        'duration',
        'status',
        'discount_type',
        'discount',
        'group_id',
    ];

    protected $appends = ['mrp', 'price'];

    protected $casts = [
        'duration' => 'integer',
    ];

    public function group(): BelongsTo
    {
        return $this->belongsTo(PackageGroup::class, 'group_id');
    }

    public function products(): HasMany
    {
        return $this->hasMany(PackageProdcut::class)
            ->with('product', 'variations.variant');
    }

    public function getMrpAttribute(): float
    {
        return $this->products()->sum('price');
    }

    public function getPriceAttribute()
    {
        $price = $this->mrp;

        if ($this->discount_type == 'flat') {
            $price = $price - $this->discount;
        } elseif ($this->discount_type == 'percentage') {
            $discount = ($this->discount / 100) * $price;
            $price = $price - $discount;
        }

        return $price;
    }
}
