<?php

namespace App\Models\Packages;

use App\Models\Products\Product;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageProdcut extends Model
{
    use HasFactory;

    protected $fillable = [
        'package_id',
        'product_id',
        'total_unit',
        'price',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class)->with('category', 'subcategory', 'variants', 'brand');
    }

    public function variations()
    {
        return $this->hasMany(PackageVariation::class, 'package_product_id');
    }
}
