<?php

namespace App\Models\Products;

use App\Casts\Money;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Variant extends Model
{
    use HasFactory;

    protected $fillable = [
        'unit',
        'mrp',
        'discount_type',
        'discount',
        'description',
        'product_id',
    ];

    protected $appends = ['price'];

    protected $casts = ['mrp' => Money::class];

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function getPriceAttribute(): array
    {
        $amount = $this->mrp['amount'];

        $price = $amount;

        if ($this->discount_type == 'flat') {
            $price = $amount - $this->discount;
        } else {
            $discount = ($this->discount / 100) * $amount;
            $price = $amount - $discount;
        }

        return Money::format($price);
    }
}
