<?php

namespace App\Models\Sliders;

use App\Shared\Active;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Slider extends Model
{
    use HasFactory, Active;

    protected $fillable = [
        'image',
        'status',
        'name',
        'parent_id'
    ];

    public function child()
    {
        return $this->hasMany(Slider::class, 'parent_id');
    }

    public function parent()
    {
        return $this->belongsTo(Slider::class, 'parent_id');
    }
}
