<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class PaymentService
{
    public function createOrder($orderAmount, string $orderId)
    {
        $headers = [
            'x-client-id' => config('cashfree.id'),
            'x-client-secret' => config('cashfree.secret'),
        ];

        $data = [
            'orderCurrency' => 'INR',
            'orderId' => $orderId,
            'orderAmount' => $orderAmount,
        ];

        $response = Http::withHeaders($headers)->post(config('cashfree.url'), $data);

        return $response->json('cftoken');
    }
}
