<?php


namespace App\Services;


use App\Models\Wallets\Wallet;

class WalletService
{
    public function credit(Wallet $wallet, $amount)
    {
        $wallet->update($this->amountCredit('balance', $wallet->balance, $amount));
    }

    public function debit(Wallet $wallet, $amount)
    {
        $wallet->update($this->amountDebit('balance', $wallet->balance, $amount));
    }

    public function creditPackage(Wallet $wallet, $amount)
    {
        $wallet->update($this->amountCredit('package', $wallet->package, $amount));
    }

    public function debitPackage(Wallet $wallet, $amount)
    {
        $wallet->update($this->amountDebit('package', $wallet->package, $amount));
    }

    public function debitCoupon(Wallet $wallet, $amount)
    {
        $wallet->update($this->amountDebit('coupon', $wallet->coupon, $amount));
    }

    public function reserve(Wallet $wallet, $amount)
    {
        $this->debit($wallet, $amount);
        $wallet->update($this->amountCredit('reserve', $wallet->reserve, $amount));
    }

    public function unreserve(Wallet $wallet, $amount)
    {
        $this->credit($wallet, $amount);
        $wallet->update($this->amountDebit('reserve', $wallet->reserve, $amount));
    }

    public function coupon(Wallet $wallet)
    {
        $amount = $wallet->coupon['amount'];

        $wallet->update(['coupon' => 0]);
        $this->credit($wallet, $amount);
    }

    public function debt(Wallet $wallet, $amount)
    {
        $wallet->update($this->amountCredit('debt', $wallet->debt, $amount));
    }

    public function undebt(Wallet $wallet, $amount)
    {
        $wallet->update($this->amountDebit('debt', $wallet->debt, $amount));
    }

    protected function amountCredit(string $key, array $price, $amount): array
    {
        return [$key => $price['amount'] + $amount];
    }

    protected function amountDebit(string $key, array $price, $amount): array
    {
        return [$key => $price['amount'] - $amount];
    }
}
