<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeliveriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('deliveries', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('area')->nullable();
            $table->string('postcode')->nullable();

            $table->foreignId('customer_id');
            $table->foreignId('order_id');
            $table->foreignId('product_id');
            $table->foreignId('variation_id');

            $table->foreignId('delivery_id')->nullable();

            $table->integer('quantity');

            $table->date('date')->nullable();
            $table->string('time')->nullable();

            $table->string('status')->default('pending');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deliveries');
    }
}
